﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ComponentModel;
using AZVIC.Ei8htPOS.Utilities;
using System.Data;

namespace AZVIC.Ei8htPOS.Entities
{
    public class AuditTrail : BusinessBaseClass
    {

        public AuditTrail()
        {

        }

        public AuditTrail(IDataReader myDataRecord)
        {
            UniqueID = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("AuditTrailID")) ? Guid.Empty : myDataRecord.GetGuid(myDataRecord.GetOrdinal("AuditTrailID"));
            ReferenceID = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("ReferenceID")) ? Guid.Empty : myDataRecord.GetGuid(myDataRecord.GetOrdinal("ReferenceID"));
            IPAddress = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("IPAddress")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("IPAddress"));
            Remarks = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("Remarks")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("Remarks"));
            UserAccountID = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("UserAccountID")) ? Guid.Empty : myDataRecord.GetGuid(myDataRecord.GetOrdinal("UserAccountID"));
            AdminUserAccountID = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("AdminUserAccountID")) ? Guid.Empty : myDataRecord.GetGuid(myDataRecord.GetOrdinal("AdminUserAccountID"));
            CreatedDate = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("CreatedDate")) ? DateTime.MinValue : myDataRecord.GetDateTime(myDataRecord.GetOrdinal("CreatedDate"));
            IsActive = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("IsActive")) ? false : myDataRecord.GetBoolean(myDataRecord.GetOrdinal("IsActive"));
            //IsDeleted = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("IsDeleted")) ? false : myDataRecord.GetBoolean(myDataRecord.GetOrdinal("IsDeleted"));
        }

        [DataObjectField(true, false, false)]
        public override Guid UniqueID { get; set; }

        public Guid ReferenceID { get; set; }

        public string IPAddress { get; set; }

        public string Remarks { get; set; }

        public Guid UserAccountID { get; set; }

        public Guid AdminUserAccountID { get; set; }

        public override DateTime CreatedDate { get; set; }

        public override DateTime ModifiedDate { get; set; }

        public override GlobalConfigurations.Mode Mode { get; set; }

        public override bool IsActive { get; set; }
    }
}
